VERSION 5.00
Object = "{4DE9E2A3-150F-11CF-8FBF-444553540000}#4.0#0"; "DlxOCX32.ocx"
Begin VB.Form Form1 
   Caption         =   "Form1"
   ClientHeight    =   7455
   ClientLeft      =   2490
   ClientTop       =   1650
   ClientWidth     =   4845
   LinkTopic       =   "Form1"
   ScaleHeight     =   7455
   ScaleWidth      =   4845
   Begin VB.Timer Timer1 
      Left            =   120
      Top             =   3120
   End
   Begin VB.CommandButton cmdClear 
      Caption         =   "Clear Over Range Flag"
      Height          =   375
      Left            =   1320
      TabIndex        =   23
      Top             =   6720
      Width           =   1935
   End
   Begin VB.Frame Frame1 
      Caption         =   "DAC Over Range Detection"
      Height          =   855
      Left            =   600
      TabIndex        =   20
      Top             =   5640
      Width           =   3135
      Begin VB.Label Label5 
         Caption         =   "Ch 7"
         BeginProperty Font 
            Name            =   "Small Fonts"
            Size            =   5.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   135
         Left            =   240
         TabIndex        =   22
         Top             =   480
         Width           =   375
      End
      Begin VB.Label Label4 
         Caption         =   "Ch 0"
         BeginProperty Font 
            Name            =   "Small Fonts"
            Size            =   5.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   2640
         TabIndex        =   21
         Top             =   480
         Width           =   375
      End
      Begin VB.Shape Shape1 
         FillColor       =   &H0000C000&
         FillStyle       =   0  'Solid
         Height          =   135
         Index           =   7
         Left            =   240
         Shape           =   3  'Circle
         Top             =   240
         Width           =   135
      End
      Begin VB.Shape Shape1 
         FillColor       =   &H0000C000&
         FillStyle       =   0  'Solid
         Height          =   135
         Index           =   6
         Left            =   600
         Shape           =   3  'Circle
         Top             =   240
         Width           =   135
      End
      Begin VB.Shape Shape1 
         FillColor       =   &H0000C000&
         FillStyle       =   0  'Solid
         Height          =   135
         Index           =   5
         Left            =   960
         Shape           =   3  'Circle
         Top             =   240
         Width           =   135
      End
      Begin VB.Shape Shape1 
         FillColor       =   &H0000C000&
         FillStyle       =   0  'Solid
         Height          =   135
         Index           =   4
         Left            =   1320
         Shape           =   3  'Circle
         Top             =   240
         Width           =   135
      End
      Begin VB.Shape Shape1 
         FillColor       =   &H0000C000&
         FillStyle       =   0  'Solid
         Height          =   135
         Index           =   3
         Left            =   1680
         Shape           =   3  'Circle
         Top             =   240
         Width           =   135
      End
      Begin VB.Shape Shape1 
         FillColor       =   &H0000C000&
         FillStyle       =   0  'Solid
         Height          =   135
         Index           =   2
         Left            =   2040
         Shape           =   3  'Circle
         Top             =   240
         Width           =   135
      End
      Begin VB.Shape Shape1 
         FillColor       =   &H0000C000&
         FillStyle       =   0  'Solid
         Height          =   135
         Index           =   1
         Left            =   2400
         Shape           =   3  'Circle
         Top             =   240
         Width           =   135
      End
      Begin VB.Shape Shape1 
         FillColor       =   &H0000C000&
         FillStyle       =   0  'Solid
         Height          =   135
         Index           =   0
         Left            =   2760
         Shape           =   3  'Circle
         Top             =   240
         Width           =   135
      End
   End
   Begin DlsrLib.DriverLINXSR SRDO 
      Left            =   120
      Top             =   2520
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin DlsrLib.DriverLINXSR SRDI 
      Left            =   120
      Top             =   1920
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin VB.TextBox Text1 
      Height          =   375
      Index           =   7
      Left            =   2640
      TabIndex        =   11
      Text            =   "0"
      Top             =   4920
      Width           =   855
   End
   Begin VB.TextBox Text1 
      Height          =   375
      Index           =   6
      Left            =   2640
      TabIndex        =   10
      Text            =   "0"
      Top             =   4440
      Width           =   855
   End
   Begin VB.TextBox Text1 
      Height          =   375
      Index           =   5
      Left            =   2640
      TabIndex        =   9
      Text            =   "0"
      Top             =   3960
      Width           =   855
   End
   Begin VB.TextBox Text1 
      Height          =   375
      Index           =   4
      Left            =   2640
      TabIndex        =   8
      Text            =   "0"
      Top             =   3480
      Width           =   855
   End
   Begin VB.TextBox Text1 
      Height          =   375
      Index           =   3
      Left            =   2640
      TabIndex        =   7
      Text            =   "0"
      Top             =   3000
      Width           =   855
   End
   Begin VB.TextBox Text1 
      Height          =   375
      Index           =   2
      Left            =   2640
      TabIndex        =   6
      Text            =   "0"
      Top             =   2520
      Width           =   855
   End
   Begin VB.TextBox Text1 
      Height          =   375
      Index           =   1
      Left            =   2640
      TabIndex        =   5
      Text            =   "0"
      Top             =   2040
      Width           =   855
   End
   Begin VB.TextBox Text1 
      Height          =   375
      Index           =   0
      Left            =   2640
      TabIndex        =   3
      Text            =   "0"
      Top             =   1560
      Width           =   855
   End
   Begin VB.CommandButton cmdSample 
      Caption         =   "Write AO Channels"
      Enabled         =   0   'False
      Height          =   375
      Left            =   600
      TabIndex        =   1
      Top             =   1080
      Width           =   1695
   End
   Begin VB.CommandButton cmdInit 
      Caption         =   "Initialize"
      Height          =   375
      Left            =   600
      TabIndex        =   0
      Top             =   600
      Width           =   1695
   End
   Begin DlsrLib.DriverLINXLDD LDD 
      Left            =   120
      Top             =   1320
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin DlsrLib.DriverLINXSR SR 
      Left            =   120
      Top             =   840
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin VB.Label Label3 
      Caption         =   "Chan 7"
      Height          =   255
      Index           =   7
      Left            =   1800
      TabIndex        =   19
      Top             =   4920
      Width           =   735
   End
   Begin VB.Label Label3 
      Caption         =   "Chan 6"
      Height          =   255
      Index           =   6
      Left            =   1800
      TabIndex        =   18
      Top             =   4440
      Width           =   735
   End
   Begin VB.Label Label3 
      Caption         =   "Chan 5"
      Height          =   255
      Index           =   5
      Left            =   1800
      TabIndex        =   17
      Top             =   3960
      Width           =   735
   End
   Begin VB.Label Label3 
      Caption         =   "Chan 4"
      Height          =   255
      Index           =   4
      Left            =   1800
      TabIndex        =   16
      Top             =   3480
      Width           =   735
   End
   Begin VB.Label Label3 
      Caption         =   "Chan 3"
      Height          =   255
      Index           =   3
      Left            =   1800
      TabIndex        =   15
      Top             =   3000
      Width           =   735
   End
   Begin VB.Label Label3 
      Caption         =   "Chan 2"
      Height          =   255
      Index           =   2
      Left            =   1800
      TabIndex        =   14
      Top             =   2520
      Width           =   735
   End
   Begin VB.Label Label3 
      Caption         =   "Chan 1"
      Height          =   255
      Index           =   1
      Left            =   1800
      TabIndex        =   13
      Top             =   2040
      Width           =   735
   End
   Begin VB.Label Label3 
      Caption         =   "Chan 0"
      Height          =   255
      Index           =   0
      Left            =   1800
      TabIndex        =   12
      Top             =   1680
      Width           =   735
   End
   Begin VB.Label Label2 
      Caption         =   "volts"
      Height          =   255
      Left            =   3600
      TabIndex        =   4
      Top             =   1680
      Width           =   615
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      BackColor       =   &H000000FF&
      Caption         =   " KEITHLEY "
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H8000000E&
      Height          =   300
      Left            =   600
      TabIndex        =   2
      Top             =   120
      Width           =   1455
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' this example was tested in Win2KSP1 with KPCI-3130
' using 3130-850A03 version of DriverLINX
'
' the KPCI-3130 supports POLLED mode analog output only
'
' a polled mode operation can write data to one DAC channel
' or can write one sample to each DAC channel in a consequative
' range of channels.  This example does a polled mode scan from
' chan 0 to the max channel on the board.
Option Explicit
Dim NumChans As Integer
Dim i As Integer


Private Sub cmdInit_Click()
' open the driver and initialize the hardware
With SR
.Req_DLL_name = "kpci3130$"
.Req_device = 0
.Req_mode = DL_OTHER
.Req_op = DL_INITIALIZE
.Req_subsystem = DL_DEVICE
.Refresh
' error check
End With
' use of the LDD control is not required for an application
' but we use it here to display the model number and to
' determine how many AO channels the board has.
If SR.Res_result = DL_NoErr Then
cmdSample.Enabled = True
LDD.Req_DLL_name = SR.Req_DLL_name
LDD.device = SR.Req_device
LDD.Refresh
Form1.Caption = LDD.Dev_Model
NumChans = LDD.AO_nChan  ' how many AO channels
' init the other two SR controls
SRDO.Req_DLL_name = SR.Req_DLL_name
SRDO.Req_device = SR.Req_device
SRDI.Req_DLL_name = SR.Req_DLL_name
SRDI.Req_device = SR.Req_device
'set up a the polled mode DI task
SetupPolledDigIn 4
'set up the polled mode DO task
SetupPolledDigOut
' the AO channels of the KPCI-3130 Series operate in 4-wire mode
'
' if the sense lines are not hooked up to read back (verify) that the
' DAC has achieved it's commanded value, then the DAC keeps increasing
' in value trying to put out enough for the Sense lines to be
' satisfied.  If the DAC reaches full scale and sense lines not yet
' satisfied, the board can tell us of this condition.  A virtual digital
' channel, chan 4, is used to keep track of DAC overrange condition.
'
Else
SR.Req_op = DL_MESSAGEBOX
SR.Refresh
End If

'If LDD.Dev_Model <> "KPCI-3130" Then
' must be the two channel KPCI-3132
' disable some channels
'For i = 2 To 7
'Text1(i).Visible = False
'Label3(i).Visible = False
'Next i
'End If


' the LDD control can inform your application
' about the features of the hardware
Form1.SetFocus  ' set focus back to this form
End Sub

Private Sub cmdSample_Click()
SetupAOScan
' read in values to write to the DAC channels
Dim AOValue(8) As Single
Dim dummy As Long
For i = 0 To NumChans - 1
AOValue(i) = CSng(Text1(i).Text)
Next i
dummy = SR.VBArrayBufferConvert(0, 0, NumChans, AOValue, DL_tSINGLE, 0, 0)
SR.Refresh  ' do it
' error check
'if no error, enable the timer
If SR.Res_result = DL_NoErr Then
Timer1.Interval = 500
Timer1.Enabled = True
End If
End Sub

Private Sub Form_Terminate()
' unload the driver for each object
SR.Req_DLL_name = ""
LDD.Req_DLL_name = ""
SRDI.Req_DLL_name = ""
SRDO.Req_DLL_name = ""
Timer1.Enabled = False
End Sub

Sub SetupAOScan()
With SR
' Request Group
.Req_op = DL_START
.Req_mode = DL_POLLED  ' no pacing clock involved
.Req_subsystem = DL_AO
' Event Group
.Evt_Str_type = DL_COMMAND  ' start when .Refresh is called
.Evt_Stp_type = DL_TCEVENT  ' stop automatically
.Evt_Tim_type = DL_NULLEVENT  ' no timing for Polled mode
' Select Group
.Sel_buf_N = 1                 ' one buffers used
.Sel_buf_samples = NumChans    ' one sample for each channel
.Sel_chan_format = DL_tNATIVE  ' use the card's native format
.Sel_chan_N = 2                ' one channel
.Sel_chan_start = 0            ' is is channel 0
.Sel_chan_startGainCode = .DLGain2Code(-1) Or &H8008 ' negative = bipolar, 1 = gain of 1
.Sel_chan_stop = NumChans - 1
.Sel_chan_stopGainCode = .DLGain2Code(-1) Or &H8008
'
' adding on the &H8008 means latch the DAC overload condition
' a DO task must be used to clear the condition once the sense line is
' hooked up
End With
End Sub

Sub SetupPolledDigOut()
With SRDO
' Request Group
.Req_op = DL_START
.Req_mode = DL_POLLED  ' no pacing clock involved
.Req_subsystem = DL_DO
' Event Group
.Evt_Str_type = DL_COMMAND  ' start when .Refresh is called
.Evt_Stp_type = DL_TCEVENT  ' stop automatically
.Evt_Tim_type = DL_NULLEVENT  ' no timing for Polled mode
' Select Group
.Sel_buf_N = 0                 ' no buffers used
.Sel_chan_format = DL_tNATIVE  ' use the card's native format
.Sel_chan_N = 1                ' one channel
.Sel_chan_start = 4         ' it is channel 4
End With
End Sub
Sub SetupPolledDigIn(chan As Integer)
With SRDI
' Request Group
.Req_op = DL_START
.Req_mode = DL_POLLED  ' no pacing clock involved
.Req_subsystem = DL_DI
' Event Group
.Evt_Str_type = DL_COMMAND  ' start when .Refresh is called
.Evt_Stp_type = DL_TCEVENT  ' stop automatically
.Evt_Tim_type = DL_NULLEVENT  ' no timing for Polled mode
' Select Group
.Sel_buf_N = 0                 ' no buffers used
.Sel_chan_format = DL_tNATIVE  ' use the card's native format
.Sel_chan_N = 1                ' one channel
.Sel_chan_start = chan         ' is is channel 4
End With
End Sub

Private Sub Timer1_Timer()
SRDI.Refresh  ' read digital channel 4 to determine the state of
              ' DAC over range bits
Dim InRange(7) As Byte
For i = 0 To 7
InRange(i) = (2 ^ i And SRDI.Res_Sta_ioValue) / 2 ^ i ' bit wise AND
Next i
For i = 0 To 7
If InRange(i) = 1 Then
Shape1(i).FillColor = vbRed
Else
Shape1(i).FillColor = vbGreen
End If
Next i
End Sub

Private Sub cmdClear_Click()
SRDO.Res_Sta_ioValue = &HFF
SRDO.Refresh
End Sub
